#ifndef TOOLBAR_H
#define TOOLBAR_H

#include <QWidget>
#include <QMouseEvent>
#include <QTimer>
#include <QStyle>
#include <QStyleOption>
#include <QPainter>
#include <QBoxLayout>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QSpacerItem>
#include <QThread>
#include <QApplication>
#include <QPushButton>
#include <QRegion>
#include <QMenu>
#include <QScreen>
#include <QRect>
#include <QMessageBox>
#include <QProcess>

#if QT_VERSION < 0x050000
#if defined(Q_OS_LINUX) || defined(Q_OS_FREEBSD)
#include <unistd.h>
#endif
#endif

#include "clientconstants.h"

#define BAR_HEIGHT 28
#define BAR_WIDTH 64
#define BAR_LENGTH 600
#define BAR_MARGIN 8
#define BUTTON_SIZE BAR_HEIGHT - 1
#define WIDTH_LIMIT 0 // 4 * BAR_HEIGHT when BAR_WIDTH is full width
#define TIME_LIMIT 300
#define ANIMATION_STEPS 10
#define ANIMATION_STEP_TIME 12 // miliseconds

class ToolBar : public QWidget
{
	Q_OBJECT
public:
	explicit ToolBar(bool vertical = false, bool fullWidth = false, QWidget *parent = 0, bool hideContainer = false);
	~ToolBar();

	void addButton(QPushButton * button);

	QPushButton * menuButton() { return _menuButton; };
    
signals:
	void entered();
	void left();
	void disconnectSession();
	void minimizeWindow();
	void refreshConnection();

public slots:

private slots:
	void timeFinished();
	void menuButtonClicked();
	void showAbout();
	void duplicateScreen();
	void extendScreen();

private:
	void enterEvent ( QEvent * );
	void leaveEvent ( QEvent * );
	void mouseMoveEvent (QMouseEvent * mouseEvent);
	void paintEvent (QPaintEvent *);
	void setRoundedCorners(int radius);
	void setMenu();

	QTimer * timer;
	QBoxLayout * layout;
	QSpacerItem * startSpacer;
	QSpacerItem * endSpacer;
	QPushButton * _menuButton;
	QMenu * menu;
	bool visible;
	bool vertical;
	bool fullWidth;
	bool hideContainer;
};

#endif // TOOLBAR_H
