#ifndef EDITSERVER_H
#define EDITSERVER_H

#include <QDialog>
#include <QString>
#include <QMessageBox>
#include <QFileDialog>
#include <QStringList>
#include <QDialogButtonBox>

#include "clientsettings.h"
#include "diskredirection.h"

namespace Ui {
class EditServer;
}

class EditServer : public QDialog
{
    Q_OBJECT

public:
    explicit EditServer(QWidget * parent, ClientSettings * settings, QString name = QString());
    ~EditServer();

public slots:
    void accept();

private slots:

    void loadSettings();
    void saveSettings();
    void on_advanced_clicked(bool checked);
    void showRedirectFileDialog();

    void on_connType_currentIndexChanged(const QString &arg1);

private:
    Ui::EditServer *ui;

    QStringList redirectedDisks;
    ClientSettings * settings;
    QString name;
    bool isNew;
};

#endif // EDITSERVER_H
